/*
 * QrfeGuiLibGlobal.cpp
 *
 *  Created on: 06.05.2011
 *      Author: stefan.detter
 */

#include "../inc/QrfeGuiLibGlobal.h"

#include <QObject>
#include <QApplication>
#include <QDesktopWidget>
#include <QString>
#include <QMessageBox>
#include <QStandardItemModel>
#include <QFileDialog>
#include <QTextStream>
#include <QDir>
#include <QRect>
#include <QList>
#include <QPair>

static QList<QColor>						_alternatingColors;
static QList< QPair<QColor,QColor> >		_alternatingRowColors;
static __init_QrfeGuiLibGlobal				__init;


bool QrfeGlobal::saveBytesToFile(const QByteArray& data, QWidget * parent, const QString & caption, const QString & dir, QString & outputFileName)
{
	QString saveName = QFileDialog::getSaveFileName(parent, caption, dir, parent->tr("CSV-File (*.csv)"));
	if(saveName.isNull())
		return false;

	QFile f(saveName);
	if(!f.open(QIODevice::WriteOnly)){
		QMessageBox::critical(parent, parent->tr("Error"), parent->tr("Could not open file."));
		return false;
	}

	outputFileName = saveName;

	QString del = ";";
	QTextStream out(&f);

	for(int i = 0; i < data.size(); i++)
	{
		out << data.mid(i, 1).toHex() << del;
	}

	f.close();

	return true;
}

bool QrfeGlobal::saveStandardModelToFile(QStandardItemModel* model, QWidget * parent, const QString & caption, const QString & dir, QString & outputFileName)
{
	QString saveName = QFileDialog::getSaveFileName(parent, caption, dir, parent->tr("CSV-File (*.csv)"));
	if(saveName.isNull())
		return false;

	QFile f(saveName);
	if(!f.open(QIODevice::WriteOnly)){
		QMessageBox::critical(parent, parent->tr("Error"), parent->tr("Could not open file."));
		return false;
	}

	outputFileName = saveName;

	QString del = ";";
	QTextStream out(&f);

	for(int j = 0; j < model->columnCount(); j++)
	{
		out << model->headerData(j, Qt::Horizontal, Qt::DisplayRole).toString().replace(QChar('\n'), QChar(' ')) << del;
	}
	out << "\n";

	for(int i = 0; i < model->rowCount(); i++)
	{
		for(int j = 0; j < model->columnCount(); j++)
		{
			out << model->data(model->index(i, j), Qt::DisplayRole).toString() << del;
		}
		out << "\n";
	}

	f.close();

	return true;
}

bool QrfeGlobal::saveStandardModelToFile(QStandardItemModel* model, QFile* file)
{
	if(!file->isOpen() && !file->isWritable()){
		return false;
	}

	QString del = ";";
	QTextStream out(file);

	for(int j = 0; j < model->columnCount(); j++)
	{
		out << model->headerData(j, Qt::Horizontal, Qt::DisplayRole).toString().replace(QChar('\n'), QChar(' ')) << del;
	}
	out << "\n";

	for(int i = 0; i < model->rowCount(); i++)
	{
		for(int j = 0; j < model->columnCount(); j++)
		{
			out << model->data(model->index(i, j), Qt::DisplayRole).toString() << del;
		}
		out << "\n";
	}

	return true;
}

bool QrfeGlobal::saveStandardModelToFile(QStandardItemModel* model, int fromRow, int count, QFile* file)
{
	if(!file->isOpen() && !file->isWritable()){
		return false;
	}

	if(fromRow < 0 || (fromRow+count) > model->rowCount())
		return false;

	QString del = ";";
	QTextStream out(file);

	for(int j = 0; j < model->columnCount(); j++)
	{
		out << model->headerData(j, Qt::Horizontal, Qt::DisplayRole).toString().replace(QChar('\n'), QChar(' ')) << del;
	}
	out << "\n";

	for(int i = 0; i < count; i++)
	{
		for(int j = 0; j < model->columnCount(); j++)
		{
			out << model->data(model->index(i + fromRow, j), Qt::DisplayRole).toString() << del;
		}
		out << "\n";
	}

	return true;
}


void QrfeGlobal::centerWidgetOnScreen (QWidget * widget)
{
     QRect rect = QApplication::desktop()->availableGeometry();
     widget->move(rect.center() - widget->rect().center());
}

QColor QrfeGlobal::getAlternatingDarkColors(int colorIndex)
{
	return _alternatingColors.at(colorIndex % _alternatingColors.size());
}

QColor QrfeGlobal::getAlternatingRowColors(int colorIndex, int rowIndex)
{
	if(rowIndex%2 == 0)
		return _alternatingRowColors.at(colorIndex % _alternatingRowColors.size()).first;
	else
		return _alternatingRowColors.at(colorIndex % _alternatingRowColors.size()).second;
}


#ifdef WIN32
#include <windows.h>
#include <winbase.h>
#endif

void QrfeGlobal::beep ( QrfeGlobal::BeepMode mode )
{
	switch(mode)
	{
	case QrfeGlobal::BEEP_INTERNAL:
#ifdef WIN32
		Beep(750, 5);
#endif
		break;
	case QrfeGlobal::BEEP_SPEAKER:
		QApplication::beep();
		break;
	case QrfeGlobal::BEEP_BOTH:
#ifdef WIN32
		Beep(750, 5);
#endif
		QApplication::beep();
		break;
	case QrfeGlobal::BEEP_OFF:
	default:
		break;
	}
}


__init_QrfeGuiLibGlobal::__init_QrfeGuiLibGlobal()
{
    QVector<QColor> colors;
    colors.reserve(6);
    colors.push_back(QColor(255, 230, 191));
    colors.push_back(QColor(255, 255, 191));
    colors.push_back(QColor(191, 255, 191));
    colors.push_back(QColor(199, 255, 255));
    colors.push_back(QColor(234, 191, 255));
    colors.push_back(QColor(255, 191, 239));
    const int darknessFactor = 110;
    for (int i = 0; i < colors.count(); i++) {
        QColor c = colors.at(i);
        _alternatingRowColors << qMakePair(c, c.darker(darknessFactor));
    }

    _alternatingColors  << Qt::darkGreen << Qt::darkBlue << Qt::darkCyan << Qt::darkMagenta << Qt::darkRed << Qt::darkYellow << Qt::darkGray;
}
